/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.updates;

import com.ibm.hsc.websm.updates.PIUpdateDefines;
import com.ibm.hsc.websm.updates.PIUpdateErrorIds;
import com.ibm.hsc.websm.updates.PIUpdateException;
import com.ibm.hwmca.base.updates.UpdateUtilities;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.util.BinaryNumber;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class PIFlashLID
implements PIUpdateErrorIds,
PIUpdateDefines {
    private static final String TRACE_MASKT = "XUPDLIDT";
    private static final String TRACE_MASKF = "XUPDLIDF";
    private static final String TRACE_MASKD = "XUPDLIDD";
    protected static final int FIPS_MIN_HEADER_LENGTH = 104;
    protected static final int FIPS_MAX_HEADER_LENGTH = 108;
    private int date;
    private boolean isAFlashLID;
    private int headerLength;
    private byte[] lidClass;
    private int lidLength;
    private long number;
    private byte[] phylum;
    private int version;

    public PIFlashLID() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> PIFlashLID()");
        Trace.trace((String)TRACE_MASKT, (Object)"<- PIFlashLID()");
    }

    public PIFlashLID(byte[] byArray) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> PIFlashLID()");
        Trace.trace((String)TRACE_MASKD, (Object)("fipsHeader.length=" + byArray.length));
        this.initFlashLID(byArray);
        Trace.trace((String)TRACE_MASKT, (Object)"<- PIFlashLID()");
    }

    public PIFlashLID(File file) throws HException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> PIFlashLID()");
        this.initAsFile(file);
        Trace.trace((String)TRACE_MASKT, (Object)"<- PIFlashLID()");
    }

    public int getDate() {
        Trace.trace((String)TRACE_MASKT, (Object)"<> getDate()");
        return this.date;
    }

    public long getNumber() {
        Trace.trace((String)TRACE_MASKT, (Object)"<> getNumber()");
        return this.number;
    }

    public int getHeaderLength() {
        Trace.trace((String)TRACE_MASKT, (Object)"<> getHeaderLength()");
        Trace.trace((String)TRACE_MASKD, (Object)("headerLength=" + this.headerLength));
        return this.headerLength;
    }

    public int getLidLength() {
        Trace.trace((String)TRACE_MASKT, (Object)"<> getLidLength()");
        Trace.trace((String)TRACE_MASKD, (Object)("lidLength=" + this.lidLength));
        return this.lidLength;
    }

    public int getVersion() {
        Trace.trace((String)TRACE_MASKT, (Object)"<> getVersion()");
        return this.version;
    }

    public boolean isBPCFSPLID() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> isBPCFSPLID");
        boolean bl = false;
        if (this.isAFlashLID) {
            Trace.trace((String)TRACE_MASKD, (Object)("this.phylum[0] = " + this.phylum[0]));
            if (this.phylum[0] == 16) {
                bl = true;
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- isBPCFSPLID returns " + (bl ? "true" : "false")));
        bl = false;
        Trace.trace((String)TRACE_MASKT, (Object)("<- isBPCFSPLID is forced to " + (bl ? "true" : "false")));
        return bl;
    }

    public boolean isCommonMarkerLID() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> isCommonMarkerLID");
        boolean bl = false;
        if (this.isAFlashLID) {
            if (this.version >= 3) {
                if (19 == this.lidClass[0] && 33 == this.lidClass[1]) {
                    bl = true;
                }
            } else if (65 == this.lidClass[0] && 0 == this.lidClass[1]) {
                bl = true;
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- isCommonMarkerLID returns " + (bl ? "true" : "false")));
        return bl;
    }

    public boolean isFSPLID() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> isFSPLID");
        boolean bl = false;
        if (this.isAFlashLID) {
            byte by = (byte)(this.lidClass[0] & 0xFFFFFFF0);
            if (by == 32) {
                bl = true;
            }
            if (by == 64) {
                bl = true;
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- isFSPLID returns " + (bl ? "true" : "false")));
        return bl;
    }

    public boolean isMasterLID() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> isMasterLID");
        boolean bl = false;
        if (this.isAFlashLID && this.version >= 3 && 19 == this.lidClass[0] && 17 == this.lidClass[1]) {
            bl = true;
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- isMasterLID returns " + (bl ? "true" : "false")));
        return bl;
    }

    public boolean isPartitionFirmwareLID() {
        byte by;
        Trace.trace((String)TRACE_MASKT, (Object)"-> isPartitionFirmwareLID");
        boolean bl = false;
        if (this.isAFlashLID && this.version >= 3 && (by = (byte)(this.lidClass[0] & 0xFFFFFFF0)) == 80) {
            bl = true;
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- isPartitionFirmwareLID returns " + (bl ? "true" : "false")));
        return bl;
    }

    public boolean isPHYPDiffLID() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> isPHYPDiffLID");
        boolean bl = false;
        if (this.isAFlashLID && this.isPHYPLID()) {
            Trace.trace((String)TRACE_MASKD, (Object)("this.number = " + this.number + " or in hex = [" + Long.toHexString(this.number) + "]"));
            long l = 2157969424L;
            Trace.trace((String)TRACE_MASKD, (Object)("diffLidNumber = " + l));
            if (this.number == l) {
                bl = true;
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- isPHYPDiffLID returns " + (bl ? "true" : "false")));
        return bl;
    }

    public boolean isPHYPLID() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> isPHYPLID");
        boolean bl = false;
        byte by = (byte)(this.lidClass[0] & 0xFFFFFFF0);
        Trace.trace((String)TRACE_MASKD, (Object)("type = " + by));
        if (by == 48) {
            bl = true;
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- isPHYPLID returns " + (bl ? "true" : "false")));
        return bl;
    }

    protected void initAsFile(File file) throws HException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> initAsFile()");
        this.isAFlashLID = false;
        int n = (int)file.length();
        Trace.trace((String)TRACE_MASKD, (Object)("lidLength=" + n));
        if (n >= 104) {
            int n2 = 108;
            if (n < n2) {
                n2 = n;
            }
            byte[] byArray = new byte[n2];
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream, n2);
                UpdateUtilities.readFully((BufferedInputStream)bufferedInputStream, (byte[])byArray);
            }
            catch (IOException iOException) {
                Trace.trace((String)TRACE_MASKF, (Object)("I/O exception reading Flash LID " + iOException));
                PIUpdateException pIUpdateException = new PIUpdateException(-2000, iOException);
                throw pIUpdateException;
            }
            this.initFlashLID(byArray);
        }
        if (!this.isAFlashLID) {
            PIUpdateException pIUpdateException = new PIUpdateException(-1999, "File [" + file.getName() + "] is not a valid LID.");
            throw pIUpdateException;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- initAsFile()");
    }

    private void initFlashLID(byte[] byArray) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> initFlashLID()");
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = new byte[2];
        byte[] byArray4 = new byte[4];
        byte[] byArray5 = new byte[4];
        byte[] byArray6 = new byte[4];
        byte[] byArray7 = new byte[2];
        this.lidClass = new byte[2];
        System.arraycopy(byArray, 2, byArray3, 0, 2);
        this.version = BinaryNumber.toInt((byte[])byArray3);
        Trace.trace((String)TRACE_MASKD, (Object)("version = " + this.version));
        System.arraycopy(byArray, 24, byArray5, 0, 4);
        this.headerLength = BinaryNumber.toInt((byte[])byArray5);
        Trace.trace((String)TRACE_MASKD, (Object)("headerLength=" + this.headerLength));
        System.arraycopy(byArray, 4, byArray2, 0, 4);
        System.arraycopy(byArray, 8, byArray4, 0, 4);
        System.arraycopy(byArray, 14, this.lidClass, 0, 2);
        System.arraycopy(byArray, 20, byArray6, 0, 4);
        this.number = BinaryNumber.toLong((byte[])byArray2);
        this.date = BinaryNumber.toInt((byte[])byArray4);
        this.lidLength = BinaryNumber.toInt((byte[])byArray6);
        Trace.trace((String)TRACE_MASKD, (Object)("Lid number = " + this.number + " or in hex [" + Long.toHexString(this.number) + "]"));
        Trace.trace((String)TRACE_MASKD, (Object)("LID class bit 0 = " + this.lidClass[0]));
        Trace.trace((String)TRACE_MASKD, (Object)("LID class bit 1 = " + this.lidClass[1]));
        System.arraycopy(byArray, 102, byArray7, 0, 2);
        int n = BinaryNumber.toInt((byte[])byArray7);
        int n2 = this.headerLength - n;
        Trace.trace((String)TRACE_MASKD, (Object)("phylumLength=" + n + " phylumIndex=" + n2));
        if (n != 0 && n2 < 108) {
            this.phylum = new byte[n];
            System.arraycopy(byArray, n2, this.phylum, 0, n);
            this.isAFlashLID = true;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- initFlashLID()");
    }
}

